package com.nexgo.apiv3demo;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.ImageDecoder;
import android.graphics.drawable.AnimatedImageDrawable;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.text.InputType;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.nexgo.common.ByteUtils;
import com.nexgo.dexlib.DexLibrary;
import com.nexgo.dexlib.DexProtocol.DexProtocolSend;
import com.nexgo.dexlib.ICallbackListeners;
import com.nexgo.mdbDemo.R;
import com.nexgo.mdbservice.ICompletionCallback;
import com.nexgo.mdbservice.IPaymentCallback;
import com.nexgo.mdbservice.PaymentAppInfo;
import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.DeviceEngine;
import com.nexgo.oaf.apiv3.SdkResult;
import com.nexgo.oaf.apiv3.device.mdb.gpio.GpioInputEnum;
import com.nexgo.oaf.apiv3.device.mdb.led.MdbLightModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.AlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.PinKeyboardModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.PinPad;
import com.nexgo.oaf.apiv3.device.pinpad.WorkKeyTypeEnum;
import com.nexgo.oaf.apiv3.device.serialport.SerialCfgEntity;
import com.nexgo.oaf.apiv3.device.serialport.SerialPortDriver;
import com.nexgo.oaf.apiv3.emv.AidEntity;
import com.nexgo.oaf.apiv3.emv.CapkEntity;
import com.nexgo.oaf.apiv3.emv.EmvHandler2;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import cn.nexgo.mdbclient.MdbServiceManager;
import cn.nexgo.mdbclient.constant.DeviceMode;
import cn.nexgo.mdbclient.constant.DeviceStatus;
import cn.nexgo.mdbclient.constant.LogLevel;
import cn.nexgo.mdbclient.constant.ReportKey;
import cn.nexgo.mdbclient.constant.ReportType;
import cn.nexgo.mdbclient.constant.TransParam;
import cn.nexgo.mdbclient.constant.TransResult;
import cn.nexgo.mdbclient.constant.VendParam;
import cn.nexgo.mdbclient.constant.VendResult;
import cn.nexgo.mdbclient.constant.VendType;


public class MainActivity extends Activity implements  View.OnClickListener, AdapterView.OnItemSelectedListener
//        ,SensorEventListener,OnScannerListener
{
    private DeviceEngine deviceEngine;

    public static final Logger mlog = LoggerFactory.getLogger(MainActivity.class.getSimpleName());
    private EmvHandler2 emvHandler2;
    private EmvUtils emvUtils;
    private PinPad pinpad;
    private static final byte[] main_key_data = new byte[16];
    private static final byte[] work_key_data = new byte[16];
    private final int KEY_INDEX = 10;
    private PaymentAppInfo paymentAppInfo;

    private Button btnOpenMdb;
    private Button btnCloseMdb;
    private Button btnBeginSession;
    private Button btnCancelSession;
    private Button btnDexProtocol;
    private Button btnStopDexProtocol;
    private Button btnAgeApprove;

    private Button btnCardPresent;

    private Button btnPulseMode_0;
    private Button btnPulseMode_1;
    private Button btnDuration_30;
    private Button btnDuration_50;
    private Button btnDuration_100;
    private Button btnPulseSetting;

    private SensorManager mSensorManager;


    private Button btnRemoteVend;


    private static byte LEVEL_3 = 0x03;
    private static byte LEVEL_2 = 0x02;
    private static byte LEVEL_1 = 0x01;
    private static byte LEVEL_DEFAULT = 0x00;
//    netca需要用level2
    private static byte FEATURE_LEVEL = LEVEL_DEFAULT;

//    LinearLayout llDeviceMode;

    private TextView tvBrandInfo;
    private ArrayList<MdbLightModeEnum> mdbLightModeEnumArrayList = new ArrayList<>();

    SerialPortDriver serialPortDriver;
//    LinearLayout llShowGif;
//    LinearLayout llShowSettings;
    private void initKey() {
        Arrays.fill(main_key_data, (byte) 0xFF);
        System.arraycopy(ByteUtils.hexString2ByteArray("F616DD76F290635EF616DD76F290635E"), 0, work_key_data, 0, 16);

        int result = pinpad.writeMKey(KEY_INDEX, main_key_data, main_key_data.length);
        mlog.debug("writeMKey result:{}", result);
        mlog.debug("isKeyExist:{}", result);
        result = pinpad.writeWKey(KEY_INDEX, WorkKeyTypeEnum.MACKEY, work_key_data, work_key_data.length);
        mlog.debug("writeWKey MACKEY result:{}", result);
        result = pinpad.writeWKey(KEY_INDEX, WorkKeyTypeEnum.PINKEY, work_key_data, work_key_data.length);
        mlog.debug("writeWKey PINKEY result:{}", result);
        result = pinpad.writeWKey(KEY_INDEX, WorkKeyTypeEnum.TDKEY, work_key_data, work_key_data.length);
        mlog.debug("writeWKey TDKEY result:{}", result);
        result = pinpad.writeWKey(KEY_INDEX, WorkKeyTypeEnum.ENCRYPTIONKEY, work_key_data, work_key_data.length);
        mlog.debug("writeWKey ENCRYPTIONKEY result:{}", result);
    }
    private void initLed(){

        mdbLightModeEnumArrayList.add(MdbLightModeEnum.MAG_BLUE);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.MAG_RED);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.MAG_GREEN);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.IC_GREEN);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.IC_BLUE);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.IC_RED);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.RF_GREEN);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.RF_BLUE);
        mdbLightModeEnumArrayList.add(MdbLightModeEnum.RF_RED);
    }
    private Handler mMainHandler;
    private Handler mInitParamHandler;
    void initData(){

        PaymentAppInfo info = new PaymentAppInfo();
        info.setClientId("90012844");
        //2.0.4
        info.setManufactureCode("XGD");          //the length should 3
        info.setModel(deviceEngine.getDeviceInfo().getModel());
        info.setCountryCode("0250");
//      ActualPrice = P * X * pow(10,-Y)  P is the price,X is the scaled factor,and y is number of decimal place
//      If  P is 100, X(scale factor) is 1, and Y(decimal place) is 2,the actual price is 1.
        info.setDecimalPlaces((byte) 0x02);
        info.setScaleFactor(1);
        info.setResponseTime((byte) 0x3C);
        info.setLogLevel(LogLevel.ALL.ordinal());   //if release,set LogLevel.INFO as default;
        info.setEnableAlwaysIdle(true);
        info.setReaderFeatureLevel(FEATURE_LEVEL);
        //only level 3 support always idle mode and monetary format
        if(FEATURE_LEVEL==LEVEL_3){
//            info.setEnableAlwaysIdle(true);
            info.setMonetaryFormat(0);  //- 0 = 16 bit monetary format, 1 = 32 bit monetary format;  set 0 as default,didn't support 1
            info.setEnableAlwaysIdle(true);
        }
//        info.setMonetaryFormat(1);
        //add 1.8.0: when the cashless device receive the ReValue cmd, if setRevalueApproved to true,
        //it will reply Revalue Approved, otherwise,reply Revalue Denied.
        info.setRevalueApproved(true);
        //add 1.8.0: set the Z8 bit0 value, the response of SETUP - Config Data(11 00) command,
        //if false,b0=0,do not request refunds, otherwise,may request the refunds.
        info.setRequestRefunds(false);
        //add 1.9.0: if set the mode to Device.TRANSMIT, the UN20 will be as man in middle role.
        info.setDeviceMode(DeviceMode.CASHLESS);
        //if set false, UN20 will not notify the status in the screen. default ture
        info.setNotifyStatus(true);
        //add 2.0.0: set true as the default value, if set true,the UN20 will ACK first,and respond command to VMC in next poll command.
        info.setRespondAckFirst(true);
        //add 2.0.1: cash sale
        info.setSupportCashSale(true);
        //add 2.0.2: device type 0 - cashless device #1  1-cashless device #2
        info.setDeviceType(0);
        //add 2.0.2: delay time(ms). 0 is default value ,if set this parameter > 0,the mdb communication will delay to read data
        info.setDelayTm(0);
        //add 2.0.3: the overtime of waiting for end session command after vend request(some USI VMC devices will not proactively cancel session).
        //           default value is 30s,the range is from 5 to 100s
        info.setWaitEndSessionTm(0);
        //2.0.4
        info.setSupportMultiVend(false);
        //2.0.4
        info.setSupportRemoteVend(false);

        paymentAppInfo = info;

    }
    private String pulseAmt = "5";
    private String pulseGap = "100";
    private String ageConfigData = "01";
    private void showInputDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Input Amount&Gap");

        // 创建一个LinearLayout来容纳两个EditText
        LinearLayout layout = new LinearLayout(this);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setPadding(16, 16, 16, 16);

        // 创建并添加第一个EditText（gap）
        final EditText gapEditText = new EditText(this);
        gapEditText.setHint("Input gap");
        gapEditText.setInputType(InputType.TYPE_NUMBER_FLAG_DECIMAL);
        gapEditText.setText("100");
        layout.addView(gapEditText);

        // 创建并添加第二个EditText（amount）
        final EditText amountEditText = new EditText(this);
        amountEditText.setHint("Input amount");
        amountEditText.setText("5");
        amountEditText.setInputType(InputType.TYPE_NUMBER_FLAG_DECIMAL);
        layout.addView(amountEditText);

        // 设置Dialog的视图
        builder.setView(layout);

        // 设置Dialog的按钮
        builder.setPositiveButton("Confirm", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 获取输入值
                pulseGap = gapEditText.getText().toString();
                pulseAmt = amountEditText.getText().toString();

            }
        });

        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 取消操作
                dialog.cancel();
            }
        });

        // 显示Dialog
        AlertDialog dialog = builder.create();
        dialog.show();
    }
    private ImageView imageView;

    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        imageView = findViewById(R.id.iv_showgif);

        btnOpenMdb = findViewById(R.id.open_mdb);
        btnCloseMdb = findViewById(R.id.close_mdb);
        btnBeginSession = findViewById(R.id.beginSession);
        btnCancelSession = findViewById(R.id.cancelSession);
        btnDexProtocol = findViewById(R.id.dexProtocol);
        btnStopDexProtocol = findViewById(R.id.stop_dexProtocol);
        btnAgeApprove = findViewById(R.id.age_approve);
        btnCardPresent = findViewById(R.id.card_present);

        btnRemoteVend = findViewById(R.id.remote_vend);


        btnPulseMode_0 = findViewById(R.id.pulse_mode_0);
        btnPulseMode_1 = findViewById(R.id.pulse_mode_1);
        btnDuration_30 = findViewById(R.id.duration_30);
        btnDuration_50 = findViewById(R.id.duration_50);
        btnDuration_100 = findViewById(R.id.duration_100);
        btnPulseSetting = findViewById(R.id.pulse_setting);

        btnOpenMdb.setOnClickListener(this);
        btnCloseMdb.setOnClickListener(this);
        btnBeginSession.setOnClickListener(this);
        btnCancelSession.setOnClickListener(this);
        btnDexProtocol.setOnClickListener(this);
        btnStopDexProtocol.setOnClickListener(this);

        btnPulseMode_0.setOnClickListener(this);
        btnPulseMode_1.setOnClickListener(this);
        btnDuration_30.setOnClickListener(this);
        btnDuration_50.setOnClickListener(this);
        btnDuration_100.setOnClickListener(this);
        btnPulseSetting.setOnClickListener(this);
        btnAgeApprove.setOnClickListener(this);
        btnCardPresent.setOnClickListener(this);

        imageView.setOnClickListener(this);
        deviceEngine = ((NexgoApplication) getApplication()).deviceEngine;
        emvHandler2 = deviceEngine.getEmvHandler2("app2");
        emvUtils = new EmvUtils(MainActivity.this);

        pinpad = deviceEngine.getPinPad();
        pinpad.setAlgorithmMode(AlgorithmModeEnum.DES);
        pinpad.setPinKeyboardMode(PinKeyboardModeEnum.FIXED);
        serialPortDriver = deviceEngine.getSerialPortDriver(1);//1:RS232-A 2:RS232-b

        HandlerThread initParamThread = new HandlerThread("initParamThread", -10);
        initParamThread.start();
        mMainHandler = new Handler(Looper.getMainLooper());
        mInitParamHandler = new Handler(initParamThread.getLooper());

        initData();
        initLed();

        mSensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);


        if(FEATURE_LEVEL==LEVEL_3&&paymentAppInfo.isEnableAlwaysIdle()){
//            setSessionButtonStatus(false);
        }else{
            setSessionButtonStatus(true);
        }
        initMdbLed();
        initPulse(pulseMode);

    }

    private void initMdbLed(){
        setMdbLed(false);
    }

    private void setMdbLed(boolean turnOn){
        for(int i=0;i<mdbLightModeEnumArrayList.size();i++){
            APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(mdbLightModeEnumArrayList.get(i), turnOn);
        }
    }
    private void postMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            mMainHandler.post(runnable);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        mlog.debug("call onResume() GData.getInstance().isInitSuccesss():{}",GData.getInstance().isInitSuccesss());

        mInitParamHandler.post(new Runnable() {
            @Override
            public void run() {
                initKey();
                initEmvAid();
                initEmvCapk();
            }
        });

        if(paymentAppInfo.isSupportRemoteVend()){
            btnRemoteVend.setVisibility(View.VISIBLE);
            btnRemoteVend.setOnClickListener(this);
        }else{
            btnRemoteVend.setVisibility(View.GONE);
        }

    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
        initMdbLed();
    }

    @Override
    protected void onDestroy() {
        mlog.debug("call onDestroy()");
        new Thread(new Runnable() {
            @Override
            public void run() {
                deviceEngine.getPlatform().enableControlBar();
                deviceEngine.getPlatform().showNavigationBar();
            }
        }).start();
        closeMdbService();
//        mKeyMonitor.unregister();
        super.onDestroy();

    }

    private void setSessionButtonStatus(boolean status){

        btnBeginSession.setVisibility(status?View.VISIBLE:View.GONE);
        btnBeginSession.setEnabled(status);
        btnBeginSession.setClickable(status);

        btnCancelSession.setVisibility(status?View.VISIBLE:View.GONE);
        btnCancelSession.setEnabled(status);
        btnCancelSession.setClickable(status);
    }
    private String brandInfo = null;
    private final ICompletionCallback iCompletionCallback = new ICompletionCallback.Stub() {
        @Override
        public void onSuccess() {
            mlog.debug("call mdbClient success!!");
        }

        @Override
        public void onFailure(final int retCode) {
            mlog.debug("call mdbClient failure retCode:{}",retCode);
            postMainThread(new Runnable() {
                @Override
                public void run() {
                    Toast.makeText(MainActivity.this,
                            "retCode:"+retCode, Toast.LENGTH_SHORT).show();
                }
            });
        }

        @Override
        public void onAppUpdate() {
            mlog.debug("call onAppUpdate() isTrading:{}",GData.getInstance().isTrading());
            if(!GData.getInstance().isTrading()){
                restartMdbService();
            }
        }

        @Override
        public void onNotifyVMCInfo(final String brand, final String model) {
            mlog.debug("brand:{} model:{}",brand,model);
            StringBuilder info = new StringBuilder();
            info.append(brand).append("|").append(model);
            brandInfo = info.toString();
        }
    };
    private DeviceStatus deviceStatus;
    private final IPaymentCallback iPaymentCallback = new IPaymentCallback.Stub() {
        @Override
        public int onPay(final int tradeType, final String itemPrice, final String itemNumber) {
            mlog.debug("call onPay() tradeType:{} itemPrice:{} itemNumber:{} isTrading:{}",
                    tradeType, itemPrice, itemNumber,GData.getInstance().isTrading());

            if(GData.getInstance().isTrading()){
                return 0;
            }
            GData.getInstance().setTrading(true);
            postMainThread(new Runnable() {
                @Override
                public void run() {
                    if(tradeType == VendType.CASH_SALE.ordinal()){
                        Toast.makeText(MainActivity.this,
                                "Cash Sale" +
                                "\n" +
                                "itemPrice:"+itemPrice +
                                "\n" +
                                "itemNumber:"+itemNumber, Toast.LENGTH_SHORT).show();
                        GData.getInstance().setTrading(false);
                    }else if(tradeType==VendType.REVALUE.ordinal()){
//                      2024/06/04  it work in multi-vend scenario
                        Toast.makeText(MainActivity.this,
                                "REVALUE" +
                                        "\n" +
                                        "itemPrice:"+itemPrice , Toast.LENGTH_SHORT).show();
                        GData.getInstance().setTrading(false);
                    }else{
                        Intent saleIntent = new Intent(MainActivity.this, EmvActivity2.class);
                        saleIntent.putExtra(TransParam.REQUEST_TYPE, tradeType);
                        saleIntent.putExtra(TransParam.ORDER_AMOUNT, itemPrice);
                        saleIntent.putExtra(TransParam.ORDER_NUMBER, itemNumber);
                        startActivityForResult(saleIntent,200);

                        APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.MAG_GREEN, true);
                        APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.RF_GREEN, true);
                        APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.IC_GREEN, true);
                    }
                }
            });
            return 0;
        }

        @Override
        public void notifyMdbStatus(final int mdbDeviceStatus) {
            deviceStatus = DeviceStatus.values()[mdbDeviceStatus];
            mlog.debug("mdbStatus:{}",DeviceStatus.values()[mdbDeviceStatus]);
            Log.d("mdbStatus", "mdbStatus:"+DeviceStatus.values()[mdbDeviceStatus]);
            if(mdbDeviceStatus == DeviceStatus.SERVICE_ERR.ordinal()){
                restartMdbService();
            }
            if(mdbDeviceStatus == DeviceStatus.INACTIVE.ordinal()){
                GData.getInstance().setTrading(false);
            }
            boolean on = (mdbDeviceStatus >= DeviceStatus.ENABLE.ordinal() && (!GData.getInstance().isTrading()));

            APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.MAG_BLUE, on);
            APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.RF_BLUE, on);
            APIProxy.getDeviceEngine(getApplicationContext()).getMdbLEDDriver().setLed(MdbLightModeEnum.IC_BLUE, on);

            if(mdbDeviceStatus == DeviceStatus.ENABLE.ordinal()){
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        if(brandInfo!=null){
//                            tvBrandInfo.setText(brandInfo);
                        }
                        progressDialog.dismiss();
//                        llShowGif.setVisibility(View.VISIBLE);
//                        llShowSettings.setVisibility(View.GONE);

                        imageView.setImageDrawable(getDrawable(R.drawable.start));
                    }
                });
            }
            if(mdbDeviceStatus == DeviceStatus.SESSION_IDLE.ordinal()){
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        deviceEngine.getPlatform().enableControlBar();
                        deviceEngine.getPlatform().showNavigationBar();
                    }
                }).start();
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        progressDialog.dismiss();
//                        llShowGif.setVisibility(View.VISIBLE);
//                        llShowSettings.setVisibility(View.GONE);

                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {

                            try {
                                AnimatedImageDrawable drawable = (AnimatedImageDrawable) ImageDecoder.decodeDrawable((ImageDecoder.createSource(getResources(), R.drawable.select_product)));
                                imageView.setImageDrawable(drawable);
                                drawable.start();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                    }
                });

            }else if(mdbDeviceStatus < DeviceStatus.ENABLE.ordinal()){
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
//                        llShowGif.setVisibility(View.GONE);
//                        llShowSettings.setVisibility(View.VISIBLE);
                    }
                });

            }
        }


        @Override
        public void notifyVendResult(int result) {
            mlog.debug("notifyVendResult:{}",VendResult.values()[result]);
            switch (VendResult.values()[result]){

                case VEND_SUCCESS:
                    deviceEngine.getCardReader().stopSearch();
//                    emvHandler2.emvProcessCancel();
                    postMainThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(MainActivity.this,"Vend Success", Toast.LENGTH_SHORT).show();
                        }
                    });
                    GData.getInstance().setTrading(false);
                    break;
                case VEND_FAILURE:
                    postMainThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(MainActivity.this,"Vend FAILURE", Toast.LENGTH_SHORT).show();
                        }
                    });
                    GData.getInstance().setTrading(false);
                    break;
                case VEND_END_SESSION:
                    postMainThread(new Runnable() {
                        @Override
                        public void run() {
                            ActivityCollector.finishAllActivity();
                            btnBeginSession.setEnabled(true);
                            btnBeginSession.setClickable(true);
                            btnCancelSession.setEnabled(true);
                            btnCancelSession.setClickable(true);
                            Toast.makeText(MainActivity.this,"End Session", Toast.LENGTH_SHORT).show();

                        }
                    });
                    GData.getInstance().setTrading(false);
                    break;

                case VEND_CANCEL:
                    mlog.debug("VEND_CANCEL");
                    deviceEngine.getCardReader().stopSearch();
                    deviceEngine.getScanner().stopScan();
                    GData.getInstance().setTrading(false);
                    JSONObject report = new JSONObject();
                    try {
                        report.put(ReportKey.TYPE,ReportType.TRADE_RESULT.ordinal());
                        report.put(ReportKey.TRADE_RESULT,TransResult.TRADE_FAILURE);
                        report.put(ReportKey.TRANS_RESULT_AMOUNT,"00");
                        MdbServiceManager.getInstance().reportToVMC(report.toString());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    mInitParamHandler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if(!paymentAppInfo.isEnableAlwaysIdle()){
                                JSONObject report = new JSONObject();
                                try {
                                    report.put(ReportKey.TYPE,ReportType.CANCEL_SESSION_REQUEST.ordinal());
                                    MdbServiceManager.getInstance().reportToVMC(report.toString());
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }, 100L);

                    postMainThread(new Runnable() {
                        @Override
                        public void run() {
                            ActivityCollector.finishAllActivity();
                            btnBeginSession.setEnabled(true);
                            btnBeginSession.setClickable(true);
                            btnCancelSession.setEnabled(true);
                            btnCancelSession.setClickable(true);
                            Toast.makeText(MainActivity.this,"End Session", Toast.LENGTH_SHORT).show();

                        }
                    });
                    GData.getInstance().setTrading(false);


                    break;

            }
        }

        @Override
        public void notifyVendParam(final int type, final byte[] data) {
            mlog.debug("type:{} data:{}", VendParam.values()[type],ByteUtils.byteArray2HexString(data));
            postMainThread(new Runnable() {
                @Override
                public void run() {
                    if(type== VendParam.IDLE_MODE.ordinal()){
                        switch (data[0]){
//                    0-idle 1-always idle
                            case 0:
                                setSessionButtonStatus(true);
                                paymentAppInfo.setEnableAlwaysIdle(false);
                                break;
                            case 1:
                            default:
                                setSessionButtonStatus(false);
                                paymentAppInfo.setEnableAlwaysIdle(true);
                                break;
                        }
                    }
                }
            });
        }

        @Override
        public void onPayResult(String payResult) {
            mlog.info("onPayResult:{}", payResult);
            Log.d("onPayResult", "onPayResult:"+payResult);
            /* json string format
                {
                    "itemSlot": 1,
                    "itemInfo": [
                        {
                            "itemAmount": "100",
                            "paymentMethod": 2
                        }
                    ],
                    "vendStatus": true,
                    "machineStatus": 0
                }
            */

            try {
                JSONObject payRes = new JSONObject(payResult);
                mlog.info("payRes:{}", payRes);
                JSONArray itemInfo = payRes.optJSONArray("itemInfo");
                int totalAmt = 0;
                for(int i=0;i<itemInfo.length();i++){
                    JSONObject itemInfoObject = itemInfo.getJSONObject(i);
                    String itemAmount = itemInfoObject.getString("itemAmount");
                    int paymentMethod = itemInfoObject.getInt("paymentMethod");
                    totalAmt += Integer.parseInt(itemAmount);
                }
                mlog.info("itemSlot:{} totalAmt:{} vendStatus:{} machineStatus:{}",
                        payRes.opt("itemSlot"),
                        totalAmt,payRes.opt("vendStatus"),
                        payRes.opt("machineStatus"));

            } catch (JSONException e) {
                throw new RuntimeException(e);
            }

        }

        @Override
        public void onCallDiagnostics(byte[] data) {
            mlog.info("User Defined Data:{}", ByteUtils.byteArray2HexString(data));
            JSONObject report = new JSONObject();
            try {
                report.put(ReportKey.TYPE, ReportType.USER_DEFINED_DATA.ordinal());
                report.put(ReportKey.USER_DEFINED_DATA,"USER TEST DATA");
                MdbServiceManager.getInstance().reportToVMC(report.toString());
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onReaderCancel() {
            mlog.info("onReaderCancel()");
        }
    };


    private void closeMdbService() {
        MdbServiceManager.getInstance().onClose();
    }

    private void restartMdbService() {
        mlog.debug("call restartMdbService()");
        MdbServiceManager.getInstance().onClose();
        MdbServiceManager.getInstance().onStart(getApplicationContext(),
                paymentAppInfo,
                iPaymentCallback,
                iCompletionCallback);
    }

    private void initEmvAid() {
        emvHandler2.delAllAid();
        if (emvHandler2.getAidListNum() <= 0) {
            List<AidEntity> aidEntityList = emvUtils.getAidList();
            if (aidEntityList == null) {
                mlog.debug("initAID failed");
                return;
            }
            int i = emvHandler2.setAidParaList(aidEntityList);
            mlog.debug("setAidParaList:{} ", i);
        } else {
            mlog.debug("setAidParaList " + "already load aid");
        }
    }


    private void initEmvCapk() {
        emvHandler2.delAllCapk();
        int capk_num = emvHandler2.getCapkListNum();
        mlog.debug("capk_num:{} ", capk_num);
        if (capk_num <= 0) {
            List<CapkEntity> capkEntityList = emvUtils.getCapkList();
            if (capkEntityList == null) {
                mlog.debug("initCAPK failed");
                return;
            }
            int j = emvHandler2.setCAPKList(capkEntityList);
            mlog.debug("setCAPKList:{} ", j);
        } else {
            mlog.debug("setCAPKList already load capk");
        }

    }
    private DexProtocolSend dexProtocolSend = new DexProtocolSend() {
        @Override
        public void write(byte[] bytes) {
            serialPortDriver.send(bytes,bytes.length);
        }

        @Override
        public byte[] read() {
            byte[] recvData = new byte[1024];
            int recvLength = serialPortDriver.recv(recvData, recvData.length,1000);
            if(recvLength>0){
                return Arrays.copyOf(recvData, recvLength);
            }else{
                return recvData;
            }

        }
    };
    private int pulseMode = 0;
    private void initPulse(final int mode){
        final int firstState = mode==0?1:0;
        deviceEngine.getGpioDriver().setOutPutGpio(GpioInputEnum.GPIO_INPUT_0_5,firstState);
    }
    private void onePulse(final int duration){

//        speed   30ms 50ms 100ms
//        gap： 100ms ...
        final int firstState = pulseMode==0?0:1;
        deviceEngine.getGpioDriver().setOutPutGpio(GpioInputEnum.GPIO_INPUT_0_5,firstState);

        try {
            Thread.sleep(duration);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        deviceEngine.getGpioDriver().setOutPutGpio(GpioInputEnum.GPIO_INPUT_0_5,firstState==1?0:1);

    }
    void multiPulse(final int duration){
        //        mode = 0: NC mode=1:NO
        final int amount = Integer.parseInt(String.valueOf(pulseAmt));
        final int gap = Integer.parseInt(String.valueOf(pulseGap));
        new Thread(new Runnable(){
            @Override
            public void run() {
                for(int i=0;i<amount;i++){
                    onePulse(duration);
                    try {
                        Thread.sleep(gap);
                    } catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                initPulse(pulseMode);
            }
        }).start();
    }
    private void showCardPresentDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Card Present");

        // 创建一个LinearLayout来容纳两个EditText
        LinearLayout layout = new LinearLayout(this);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setPadding(16, 16, 16, 16);

        // 创建并添加第一个EditText（gap）
        final EditText gapEditText = new EditText(this);
        gapEditText.setHint("Input Age Verification Approved Data");
        gapEditText.setInputType(InputType.TYPE_NUMBER_FLAG_DECIMAL);
        gapEditText.setText(ageConfigData);
        layout.addView(gapEditText);



        // 设置Dialog的视图
        builder.setView(layout);

        // 设置Dialog的按钮
        builder.setPositiveButton("Confirm", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 获取输入值
                ageConfigData = gapEditText.getText().toString();
                JSONObject age = new JSONObject();
                try {
                    age.put(ReportKey.TYPE, ReportType.USER_DEFINED_DATA.ordinal()+2);
                    age.put(ReportKey.USER_DEFINED_DATA,ageConfigData);
                    MdbServiceManager.getInstance().reportToVMC(age.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        Toast.makeText(MainActivity.this,"AGE VERIFICATION APPROVED", Toast.LENGTH_SHORT).show();
                    }
                });
            }
        });

        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 取消操作
                dialog.cancel();
            }
        });

        // 显示Dialog
        AlertDialog dialog = builder.create();
        dialog.show();
    }
    private void showConfigDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Config Data");

        // 创建一个LinearLayout来容纳两个EditText
        LinearLayout layout = new LinearLayout(this);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setPadding(16, 16, 16, 16);

        // 创建并添加第一个EditText（gap）
        final EditText gapEditText = new EditText(this);
        gapEditText.setHint("Input Age Verification Approved Data");
        gapEditText.setInputType(InputType.TYPE_NUMBER_FLAG_DECIMAL);
        gapEditText.setText(ageConfigData);
        layout.addView(gapEditText);



        // 设置Dialog的视图
        builder.setView(layout);

        // 设置Dialog的按钮
        builder.setPositiveButton("Confirm", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 获取输入值
                ageConfigData = gapEditText.getText().toString();
                JSONObject age = new JSONObject();
                try {
                    age.put(ReportKey.TYPE, ReportType.USER_DEFINED_DATA.ordinal()+1);
                    age.put(ReportKey.USER_DEFINED_DATA,ageConfigData);
                    MdbServiceManager.getInstance().reportToVMC(age.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        Toast.makeText(MainActivity.this,"AGE VERIFICATION APPROVED", Toast.LENGTH_SHORT).show();
                    }
                });
            }
        });

        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 取消操作
                dialog.cancel();
            }
        });

        // 显示Dialog
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private boolean isReadCard = false;
    private ProgressDialog progressDialog;
    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.card_present:
                showCardPresentDialog();
                break;

            case R.id.age_approve:
                showConfigDialog();

                break;
            case R.id.pulse_setting:
                showInputDialog();
//                deviceEngine.getPinPad().setDukptAlgorithmMode(DukptAlgorithmModeEnum.DES);
//                JSONObject reset = new JSONObject();
//                try {
//                    reset.put(ReportKey.TYPE, ReportType.RESET_DEVICE.ordinal());
//                    MdbServiceManager.getInstance().reportToVMC(reset.toString());
//                } catch (JSONException e) {
//                    e.printStackTrace();
//                }
                break;
            case R.id.pulse_mode_0:
                pulseMode = 0;
                initPulse(pulseMode);
                break;
            case R.id.pulse_mode_1:
                pulseMode = 1;
                initPulse(pulseMode);
                break;
            case R.id.duration_30:
                initPulse(pulseMode);
                multiPulse(29);
                break;
            case R.id.duration_50:
                initPulse(pulseMode);
                multiPulse(49);
                break;
            case R.id.duration_100:
                initPulse(pulseMode);
                multiPulse(99);
                break;
            case R.id.remote_vend:
                JSONObject report = new JSONObject();
                try {
                    report.put(ReportKey.TYPE, ReportType.SELECTION_REQUEST.ordinal());
                    report.put(ReportKey.FUNDS,"00C8");
                    report.put(ReportKey.ITEMNUMBER,"0001");
                    report.put(ReportKey.ITEMOPTION,"1");
                    MdbServiceManager.getInstance().reportToVMC(report.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        Toast.makeText(MainActivity.this,"REMOTE VEND", Toast.LENGTH_SHORT).show();
                    }
                });
                break;

            case R.id.stop_dexProtocol:
//                multiPulse(10,30,100);
                serialPortDriver.disconnect();
                report = new JSONObject();
                try {
                    report.put(ReportKey.TYPE, ReportType.RESET_DEVICE.ordinal());
                    MdbServiceManager.getInstance().reportToVMC(report.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
//                mlog.error("getMDBReceiveTimestamp:{}",stampToDate(MdbServiceManager.getInstance().getMDBReceiveTimestamp()));
                break;
            case R.id.dexProtocol:
//                multiPulse(5,50,100);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        SerialCfgEntity serialCfgEntity = new SerialCfgEntity();
                        serialCfgEntity.setBaudRate(9600);
                        serialCfgEntity.setDataBits(8);
                        serialCfgEntity.setParity('n');
                        serialCfgEntity.setStopBits(1);
                        int ret = serialPortDriver.connect(serialCfgEntity);
                        mlog.debug("serialPortDriver.connect ret:{}",ret);
                        if (ret == SdkResult.Success){
                            final DexLibrary dexLibrary = DexLibrary.getSelfInstance(MainActivity.this,dexProtocolSend);

                            dexLibrary.setResponseListener(new ICallbackListeners() {
                                @Override
                                public void listenerResponseCommand(String s) {
                                    mlog.debug("listenerResponseCommand:{}",s);
                                    try {
                                        JSONObject jsonObject = new JSONObject(s);
                                        if(jsonObject!=null){
                                            String command = jsonObject.getString("command");
                                            if(command.equals("INIT")){
                                                dexLibrary.write("PC1*COL 1*25*Mint 1");
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                            dexLibrary.exexecuteCommand("INIT",new String[]{"UN20"});

/*                            dexLibrary.setResponseListener(new ICallbackListeners() {
                                @Override
                                public void listenerResponseCommand(String s) {
                                    mlog.debug("listenerResponseCommand:{}",s);
                                    try {
                                        JSONObject jsonObject = new JSONObject(s);
                                        if(jsonObject!=null){
                                            String command = jsonObject.getString("command");
                                            if(command.equals("INIT")){
                                                dexLibrary.exexecuteCommand("GETAUDITDATA",null);
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                            dexLibrary.exexecuteCommand("INIT",new String[]{"UN20"});*/
                        }
                    }
                }).start();

                break;

            case R.id.open_mdb:
                mlog.debug("start to open mdb!!");
                GData.getInstance().setTrading(false);
                MdbServiceManager.getInstance().onStart(getApplicationContext(),
                        paymentAppInfo,
                        iPaymentCallback,
                        iCompletionCallback);

                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        btnOpenMdb.setClickable(false);
                        btnOpenMdb.setEnabled(false);
                    }
                });
                deviceEngine.getPlatform().disableControlBar();
                deviceEngine.getPlatform().hideNavigationBar();

//                deviceEngine.getPlatform().enableDataRoaming();
//                deviceEngine.getPlatform().enableMobileData();

                progressDialog = new ProgressDialog(MainActivity.this);//1.创建一个ProgressDialog的实例
                progressDialog.setMessage("MDB INIT，PLEASE WAIT......");//3.设置显示内容
                progressDialog.setCancelable(true);//4.设置可否用back键关闭对话框
                progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
                    @Override
                    public void onCancel(DialogInterface dialogInterface) {
                        GData.getInstance().setTrading(false);
                        closeMdbService();
                        initMdbLed();
                        postMainThread(new Runnable() {
                            @Override
                            public void run() {
                                btnOpenMdb.setClickable(true);
                                btnOpenMdb.setEnabled(true);


                                setSessionButtonStatus(true);
                            }
                        });
                        deviceEngine.getPlatform().enableControlBar();
                        deviceEngine.getPlatform().showNavigationBar();
                    }
                });
                progressDialog.show();//5.将ProgessDialog显示出来
                break;
            case R.id.close_mdb:
                mlog.debug("close mdb!!");
                GData.getInstance().setTrading(false);
                closeMdbService();
                initMdbLed();
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        btnOpenMdb.setClickable(true);
                        btnOpenMdb.setEnabled(true);

                        setSessionButtonStatus(true);
                    }
                });
                deviceEngine.getPlatform().enableControlBar();
                deviceEngine.getPlatform().showNavigationBar();
                break;

            case R.id.beginSession:
            case R.id.iv_showgif:
                JSONObject begin = new JSONObject();
                try {
                    begin.put(ReportKey.TYPE, ReportType.BEGIN_SESSION.ordinal());
                    begin.put(ReportKey.FUNDS,"FFFE");
                    MdbServiceManager.getInstance().reportToVMC(begin.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        Toast.makeText(MainActivity.this,"BEGIN SESSION", Toast.LENGTH_SHORT).show();
                    }
                });

/*                if(!isReadCard){
                    postMainThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(MainActivity.this,"Please Tap/Insert Bank card", Toast.LENGTH_SHORT).show();
                        }
                    });

                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            HashSet<CardSlotTypeEnum> slotTypes = new HashSet<>();
                            slotTypes.add(CardSlotTypeEnum.ICC1);
                            slotTypes.add(CardSlotTypeEnum.RF);
                            slotTypes.add(CardSlotTypeEnum.SWIPE);
                            isReadCard = true;
                            deviceEngine.getCardReader().searchCard(slotTypes, 15, new OnCardInfoListener() {
                                @Override
                                public void onCardInfo(int code, CardInfoEntity cardInfoEntity) {
                                    deviceEngine.getCardReader().stopSearch();
                                    isReadCard = false;
                                    if(code==SdkResult.Success){
                                        JSONObject report = new JSONObject();
                                        try {
                                            report.put(ReportKey.TYPE, ReportType.BEGIN_SESSION.ordinal());
                                            report.put(ReportKey.FUNDS,"FFFE");
                                            MdbServiceManager.getInstance().reportToVMC(report.toString());
                                        } catch (JSONException e) {
                                            e.printStackTrace();
                                        }
                                        postMainThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                Toast.makeText(MainActivity.this,"BEGIN SESSION", Toast.LENGTH_SHORT).show();
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void onSwipeIncorrect() {
                                    deviceEngine.getCardReader().stopSearch();
                                    isReadCard = false;
                                }

                                @Override
                                public void onMultipleCards() {
                                    deviceEngine.getCardReader().stopSearch();
                                    isReadCard = false;
                                }
                            });
                        }
                    }).start();
                }*/

                break;

            case R.id.cancelSession:
                JSONObject cancelReport = new JSONObject();
                try {
                    cancelReport.put(ReportKey.TYPE, ReportType.CANCEL_SESSION_REQUEST.ordinal());
                    MdbServiceManager.getInstance().reportToVMC(cancelReport.toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            default:
                break;
        }
    }




    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mlog.debug("onActivityResult requestCode:{} resultCode:{}",requestCode,resultCode);
        if (requestCode == 200&&resultCode==1) {
            if(data!=null){
                final int result = data.getIntExtra("TransResult",TransResult.TRADE_UNKNOWN.ordinal());
                final String transAmount = data.getStringExtra("TransAmount");
                mlog.debug("result:{} transAmount:{}",result,transAmount);
                mInitParamHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        JSONObject report = new JSONObject();
                        try {
                            report.put(ReportKey.TYPE,ReportType.TRADE_RESULT.ordinal());
                            report.put(ReportKey.TRADE_RESULT,result);
                            report.put(ReportKey.TRANS_RESULT_AMOUNT,transAmount);
                            MdbServiceManager.getInstance().reportToVMC(report.toString());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
                mInitParamHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if(result==TransResult.TRADE_FAILURE.ordinal()){
                            if(!paymentAppInfo.isEnableAlwaysIdle()){
                                JSONObject report = new JSONObject();
                                try {
                                    report.put(ReportKey.TYPE,ReportType.CANCEL_SESSION_REQUEST.ordinal());
                                    MdbServiceManager.getInstance().reportToVMC(report.toString());
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                            GData.getInstance().setTrading(false);
                        }
                    }
                }, 100L);
            }
        }
    }



    @Override
    public void onItemSelected(AdapterView<?> adapterView, View view, int index, long l) {

    }

    @Override
    public void onNothingSelected(AdapterView<?> adapterView) {

    }

    public static String stampToDate(Long s){
        String res;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(s);
        res = simpleDateFormat.format(date);
        return res;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        Log.d("onKeyDown","keyCode:"+keyCode);
        if(keyCode == KeyEvent.KEYCODE_BACK){
            Log.d("onKeyDown","deviceStatus:"+deviceStatus);
//            mlog.debug("deviceStatus:{}",deviceStatus);
            if(deviceStatus==DeviceStatus.SESSION_IDLE){
                postMainThread(new Runnable() {
                    @Override
                    public void run() {
                        imageView.setImageDrawable(getDrawable(R.drawable.start));
                    }
                });
                return false;
            }else{
                return super.onKeyDown(keyCode,event);
            }
        }else{
            return super.onKeyDown(keyCode,event);
        }
    }
/*
    @Override
    public void onHomeClick() {

    }

    @Override
    public void onRecentClick() {
        Log.d("onKeyDown","call onRecentClick()");
    }*/


}
